using Newtonsoft.Json;
using NLog;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Runtime.InteropServices;
using Excel = Microsoft.Office.Interop.Excel;

namespace ExcelAddInDg
{
    public class RowRangeModel
    {
        public string startRowRid { get; set; }
        public string endRowRid { get; set; }
    }
    internal partial class ExcelEventSubscriptions
    {
        private Excel.Workbook _activeWorkbook;
        private Excel.Worksheet _activeWorksheet;
        private int _lastUsedRows;
        private Excel.Range _lastHighlightedRow; // ڸһθ

        private static readonly Logger LogManagerCall = LogManager.GetCurrentClassLogger();

        // 򿪹Ĵ߼еļУڹ¼
        private void OnWorkbookOpen(Excel.Workbook workbook)
        {
            try
            {
                LogManagerCall.Info("Workbook opened: {0}", workbook?.Name);
                // ڴӴ򿪹ʱҪִе߼
                InitializeWorksheetTracking(workbook);
            }
            catch (Exception ex)
            {
                LogManagerCall.Error(ex, "OnWorkbookOpen 쳣");
            }
        }

        private void OnWorkbookActivate(Excel.Workbook workbook) {
            try
            {
                LogManagerCall.Info("OnWorkbookActivate opened: {0}", workbook?.Name);
                // ڴӴ򿪹ʱҪִе߼
                InitializeWorksheetTracking(workbook);
            }
            catch (Exception ex)
            {
                LogManagerCall.Error(ex, "OnWorkbookActivate 쳣");
            }
        }

        // ڼ¼
        private void Application_WindowActivate(Excel.Workbook Wb, Excel.Window Wn)
        {
            if (Wn.Application.ActiveWorkbook != null)
            {
                InitializeWorksheetTracking(Wb);
            }
        }

        // лʱ
        private void OnSheetActivated(object Sh)
        {
            if (Sh is Excel.Worksheet sheet)
            {
                // ɹ¼
                if (_activeWorksheet != null)
                {
                    ReleaseComObjectSafe(_activeWorksheet);
                }

                // ¹
                _activeWorksheet = sheet;
                _activeWorkbook = sheet.Parent as Excel.Workbook;

                if (!_activeWorksheet.ProtectContents)
                {
                    _lastUsedRows = GetUsedRowCount(sheet);
                    var ComCount1 = FindSpecialComments(_activeWorksheet, "}.");
                    LogManagerCall.Debug($"ǰsheetҳ{_activeWorkbook.Name},{_activeWorksheet.Name}{ComCount1.Count()}");
                    if (ComCount1.Count() > 0)
                    {
                        // Ƚٰ󶨣ȷֻһ
                        sheet.Change -= OnWorksheetChanged;
                        sheet.Change += OnWorksheetChanged;
                    }
                }
            }
        }

        // ڴļмӸ¼磺
        // private void OnSomeOtherEvent(...) { ... }

        // ݱ仯¼
        private void OnWorksheetChanged(Excel.Range Target)
        {
            try
            {
                LogManagerCall.Debug($"sheetҳݱ䶯{Target.Address} λкţ{Target.Row}");
                int currentRows = GetUsedRowCount(_activeWorksheet);
                LogManagerCall.Debug($"仯:vs ǰ- {currentRows} vs {_lastUsedRows}");

                if (currentRows == _lastUsedRows)
                {
                    return;
                }
                if (currentRows < _lastUsedRows)
                {
                    // ɾв
                    _lastUsedRows = currentRows;
                    return;
                }

                if (currentRows > _lastUsedRows)
                {
                    int insertedRowCount = currentRows - _lastUsedRows;
                    int startRow = Target.Row;

                    // ¼
                    HandleRowInserted(startRow, insertedRowCount);
                    _lastUsedRows = currentRows;
                }
            }
            catch (Exception ex)
            {
                System.Diagnostics.Debug.WriteLine($"䶯: {ex.Message}");
                LogManagerCall.Debug($"䶯: {ex.Message.ToString()}");
            }
        }

        private void HandleRowInserted(int startRow, int rowCount)
        {
            string message = $"⵽Уʼ {startRow},  {rowCount} ";
            System.Diagnostics.Debug.WriteLine(message);

            //_logPanelHost.AppendLog(message);
            Excel.Worksheet worksheet = Globals.ThisAddIn.Application.ActiveSheet as Excel.Worksheet;
            if (worksheet == null) return;
            //һ׶Σа "p1" ע
            List<Excel.Range> targetComments = FindCommentsWithPattern(worksheet, ".{зΧ}.");
            LogManagerCall.Debug($"sheet{worksheet.Name} 鸡 {targetComments.Count} ");
            foreach (Excel.Range commentCell in targetComments)
            {
                try
                {
                    // ڶ׶Σע
                    var comment = commentCell.Comment;
                    string commentText = comment.Text();
                    string[] parts = commentText.Split(new[] { ".{зΧ}." }, StringSplitOptions.RemoveEmptyEntries);

                    if (parts.Length < 2) continue;

                    // ȡ JSON 
                    string jsonPart = parts[1].Trim()
                        .Split(new[] { '\r', '\n' }, StringSplitOptions.RemoveEmptyEntries)
                        .FirstOrDefault()?
                        .Trim('"', ' ', ';');

                    if (string.IsNullOrEmpty(jsonPart)) continue;

                    // ׶Σ JSON
                    List<RowRangeModel> ranges = JsonConvert.DeserializeObject<List<RowRangeModel>>(jsonPart);
                    if (ranges == null || ranges.Count == 0) continue;
                    LogManagerCall.Debug($"עʼгɹ{jsonPart} {ranges.Count} ǰע{parts[0]}");

                    foreach (var range in ranges)
                    {
                        // Ľ׶Σ RID Ӧк
                        Dictionary<string, int> ridRowMap = new Dictionary<string, int>();
                        FindRidRows(worksheet, new[] { range.startRowRid, range.endRowRid }, ridRowMap, parts[0]);

                        string message3 = $"вע{ridRowMap.Count()}: startRowRid{range.startRowRid} endRowRid{range.endRowRid}";
                        LogManagerCall.Debug(message3);
                        if (!ridRowMap.ContainsKey(range.startRowRid)) continue;
                        if (!ridRowMap.ContainsKey(range.endRowRid)) continue;

                        int rstartRow = ridRowMap[range.startRowRid];
                        int endRow = ridRowMap[range.endRowRid];
                        int currentRow = startRow;
                        string message0 = $"в飺ʼ {rstartRow} -{endRow}  ǰ {currentRow} ";
                        LogManagerCall.Info(message0);
                        // ׶Σ֤зΧ
                        if (currentRow > Math.Min(rstartRow, endRow) &&
                            currentRow < Math.Max(rstartRow, endRow))
                        {

                            HighlightCurrentRow(worksheet, parts[0], rowCount);

                          
                        }
                    }
                }
                catch (JsonException) { /* JSON ʧ */ }
                catch (COMException) { /* Excel 쳣 */ }
                finally
                {
                    // ͷ COM 
                    if (commentCell != null) Marshal.ReleaseComObject(commentCell);
                }
                // ҵ߼Զ乫ʽ


            }
            //MessageBox.Show(message, "м", MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        // ķõǰбɫ
        public void HighlightCurrentRow(Excel.Worksheet worksheet, string noteName, int addRow)
        {
            try
            {
                Excel.Application excelApp = Globals.ThisAddIn.Application;

                Excel.Range selectedRange = excelApp.Selection as Excel.Range;
                if (selectedRange == null) return;

                if (worksheet == null) return;
                int firstUsedColumn = -1;

                List<string> usedColumns = FindSpecialComments(worksheet, noteName + ".{ͷ}");
                if (usedColumns.Count == 0)
                {
                    List<string> usedRow = FindSpecialComments(worksheet, noteName + ".{ͷ}");
                    if (usedRow.Count > 0)
                    {
                        // List<string>  a Ǹַбתҵ
                        firstUsedColumn = usedRow.Select(int.Parse).Max(); // תҵֵ


                    }
                }
                else
                {
                    firstUsedColumn = int.Parse(usedColumns.First()); // ת usedColumns.First()

                }

                if (firstUsedColumn > 0)
                {

                    LogManagerCall.Debug($"⵽ǰsheet{worksheet.Name}ҳ{firstUsedColumn}");
                    // λĿзΧ (ӵ1е)
                    Excel.Range targetRow = worksheet.Range[
                        worksheet.Cells[selectedRange.Row, 2],
                        worksheet.Cells[selectedRange.Row + addRow - 1, firstUsedColumn]
                    ];

                    // ɸ
                    //ClearPreviousHighlight();

                    // ±ɫǳɫʾ191 G213 B238)
                    //targetRow.Interior.Color = RGB(255, 255, 153); // ʹԶRGB
                    targetRow.Interior.Color = RGB(191, 213, 238); // ʹԶRGB
                    _lastHighlightedRow = targetRow;

                }




                // ͷŶtargetRowںлʹãʱͷţ
            }
            catch (COMException ex)
            {
                System.Diagnostics.Debug.WriteLine($"COM Error: {ex.Message}");

            }
            finally
            {
                // ȷͷŷǱҪ
                //if (selectedRange != null) Marshal.ReleaseComObject(selectedRange);
                //if (worksheet != null) Marshal.ReleaseComObject(worksheet);
            }
        }

        // ȡǰŻ߼
        private int GetUsedColumns(Excel.Worksheet worksheet, int row)
        {
            // ʽ1ͨUsedRangeټ⣨ʺϹݱ
            Excel.Range usedRange = worksheet.UsedRange;
            int maxUsedColumn = usedRange.Column + usedRange.Columns.Count - 1;

            // ʽ2ȷ⣨Уʺϲݣ
            // int dynamicMaxCol = 1;
            // for (int col = 1; col <= 16384; col++)
            // {
            //     {
            //         dynamicMaxCol = col;
            //     }
            // }

            Marshal.ReleaseComObject(usedRange);
            return maxUsedColumn; // 򷵻 dynamicMaxCol
        }

        // ԶRGBתExcelʹBGR˳
        private int RGB(int r, int g, int b)
        {
            return (b << 16) | (g << 8) | r;
        }


        // ʼ׷
        private void InitializeWorksheetTracking(Excel.Workbook Wb)
        {
            try
            {
                LogManagerCall.Debug($"ʼǰɣ{Wb.Name},{_lastUsedRows}");
                _activeWorkbook = Wb.Application.ActiveWorkbook;
                _activeWorksheet = _activeWorkbook.ActiveSheet as Excel.Worksheet;

                if (_activeWorksheet != null)
                {


                    LogManagerCall.Debug($"ʼǰɣ{_activeWorksheet.Name},{_lastUsedRows}");
                    //var ComCount = FindSpecialComments(_activeWorksheet);
                    //if (ComCount.Count > 0)
                    //{
                    //    _activeWorksheet.Change += OnWorksheetChanged;
                    //}
                    //_activeWorksheet.Change += OnWorksheetChanged;
                    if (!_activeWorksheet.ProtectContents)
                    {
                        _lastUsedRows = GetUsedRowCount(_activeWorksheet);
                        var ComCount1 = FindSpecialComments(_activeWorksheet, "}.");
                        LogManagerCall.Debug($"ǰsheetҳ{_activeWorksheet.Name}{ComCount1.Count()}");
                        if (ComCount1.Count() > 0)
                        {

                            _activeWorksheet.Change -= OnWorksheetChanged;
                            _activeWorksheet.Change += OnWorksheetChanged;
                        }
                    }


                }
            }
            catch (COMException ex)
            {
                System.Diagnostics.Debug.WriteLine($"ʼ: {ex.Message}");
                LogManagerCall.Debug($"ʼ: {ex.Message}");
            }
        }

        /****************** ߺ ******************/
        // ҰָģʽעԪ
        private List<Excel.Range> FindCommentsWithPattern(Excel.Worksheet worksheet, string pattern)
        {
            var result = new List<Excel.Range>();
            Excel.Range commentsRange = null;

            try
            {
                commentsRange = worksheet.Cells.SpecialCells(
                    Excel.XlCellType.xlCellTypeComments,
                    Type.Missing);

                foreach (Excel.Range cell in commentsRange)
                {
                    try
                    {
                        if (cell.Comment?.Text().Contains(pattern) == true)
                        {
                            result.Add(cell);
                        }
                        else
                        {
                            Marshal.ReleaseComObject(cell);
                        }
                    }
                    catch { /* ЧԪ */ }
                }
            }
            catch (COMException) { /* ע */ }
            finally
            {
                if (commentsRange != null) Marshal.ReleaseComObject(commentsRange);
            }

            return result;
        }


        //  RID Ӧʵк
        private void FindRidRows(Excel.Worksheet worksheet, string[] rids, Dictionary<string, int> resultMap, string noteName)
        {
            Excel.Range commentsRange = null;

            try
            {
                commentsRange = worksheet.Cells.SpecialCells(
                    Excel.XlCellType.xlCellTypeComments,
                    Type.Missing);


                foreach (Excel.Range cell in commentsRange)
                {
                    try
                    {
                        string commentText = cell.Comment?.Text();
                        if (string.IsNullOrEmpty(commentText)) continue;

                        foreach (var rid in rids)
                        {
                            if (commentText.Contains(rid) && commentText.Contains("ñ") && !resultMap.ContainsKey(rid))
                            {
                                resultMap[rid] = cell.Row;
                            }
                            if (rid == "last")
                            {
                                List<Excel.Range> targetComments = FindCommentsWithPattern(worksheet, noteName + ".{ע}");
                                if (targetComments.Count > 0)
                                {
                                    resultMap[rid] = targetComments.Last().Row;
                                    LogManagerCall.Debug($"⵽עͣ{targetComments.Last().Address}кţ{resultMap[rid]}");

                                }
                            }
                        }
                    }
                    finally
                    {
                        Marshal.ReleaseComObject(cell);
                    }
                }


            }
            catch (COMException) { /* ע */ }
            finally
            {
                if (commentsRange != null) Marshal.ReleaseComObject(commentsRange);
            }
        }

        // ȡǰŻܰ棩
        private int GetUsedRowCount(Excel.Worksheet sheet)
        {



            int rowCount = 0;
            Excel.Range usedRange = sheet.UsedRange;

            try
            {
                // ӵ1пʼֱ5Ϊֹ
                for (int i = 1; i <= usedRange.Rows.Count; i++)
                {
                    if (!string.IsNullOrEmpty(sheet.Cells[i, 1].Text.ToString()))
                    {
                        rowCount = i;
                    }
                    else if (i > rowCount + 5) // 5Ϊ
                    {
                        break;
                    }
                }
                return rowCount;
            }
            finally
            {
                ReleaseComObjectSafe(usedRange);
            }
        }
        public List<string> FindSpecialComments(Excel.Worksheet wksheet, string kword = ".{зΧ}.")
        {
            List<string> result = new List<string>();

            if (wksheet == null) return result;
            Excel.Worksheet worksheet = wksheet;
            Excel.Range commentsRange = null;
            try
            {
                string sheetName = worksheet.Name;
                // ȡаעĵԪ
                commentsRange = worksheet.Cells.SpecialCells(
                    Excel.XlCellType.xlCellTypeComments,
                    Type.Missing
                );

                // ÿעĵԪ
                foreach (Excel.Range cell in commentsRange)
                {
                    Excel.Comment comment = null;
                    try
                    {
                        comment = cell.Comment;
                        if (comment != null)
                        {
                            // ȡעı
                            string commentText = comment.Text();

                            // ǷĿַ
                            if (commentText.Contains(kword))
                            {
                                string address = cell.Address;
                                LogManagerCall.Debug($"ҵע{sheetName}Ԫַ{address}еַ{cell.Column.ToString()}");
                                result.Add($"{cell.Column.ToString()}");
                            }
                        }
                    }
                    finally
                    {
                        ReleaseComObjectSafe(comment);
                        ReleaseComObjectSafe(cell);
                    }
                }
            }
            catch (COMException ex)
            {
                LogManagerCall.Debug(ex.ToString());
                // עSpecialCells ҲĿʱ쳣
                if (!ex.Message.Contains("δҵԪ"))
                {
                    LogManagerCall.Debug("!δҵԪ");
                    //MessageBox.Show(ex.ToString());
                }

            }
            finally
            {
                ReleaseComObjectSafe(commentsRange);
            }


            return result;
        }

        #region COM 
        private void ReleaseComObjectSafe(object comObj)
        {
            try
            {
                if (comObj == null) return;
                // ֻ COM Ҫͷţųԭʼ
                if (Marshal.IsComObject(comObj))
                {
                    while (Marshal.ReleaseComObject(comObj) > 0) { }
                }
            }
            catch (Exception ex)
            {
                Debug.WriteLine("ReleaseComObjectSafe error: " + ex);
            }
        }
        #endregion

    }
}