using System;
using System.Diagnostics;
using System.Collections.Generic;
using Excel = Microsoft.Office.Interop.Excel;
using NLog;

namespace ExcelAddInDg
{
    /// <summary>
    /// ȡ Excel Ӧü¼򿪹رǰȣ
    ///  ThisAddIn.Startup д Subscribe Shutdown е Unsubscribe  Dispose
    /// </summary>
    internal partial class ExcelEventSubscriptions : IDisposable
    {
        private static readonly Logger Logger = LogManager.GetCurrentClassLogger();

        private readonly Excel.Application _excelApp;
        private readonly Excel.AppEvents_Event _appEvents;
        private bool _disposed = false;
        // ֶ delegate Էֹ GC գ COM ¼ĳӣ
        private Excel.AppEvents_WorkbookOpenEventHandler _workbookOpenHandler;
        private Excel.AppEvents_WorkbookActivateEventHandler _workbookActivateHandler;

        // ֶ Application.SheetActivate ãֹ GC 
        private Excel.AppEvents_SheetActivateEventHandler _sheetActivateHandler;

        // ֶ WindowActivate ãֹ GC 
        private Excel.AppEvents_WindowActivateEventHandler _windowActivateHandler;

        // ָֻĳЩЧΪйЧ
        private readonly HashSet<string> _watchedWorkbookNames = new HashSet<string>(StringComparer.OrdinalIgnoreCase);

        private bool _isSubscribed;

        public ExcelEventSubscriptions(Excel.Application excelApplication)
        {
            _excelApp = excelApplication ?? throw new ArgumentNullException(nameof(excelApplication));
            _appEvents = _excelApp as Excel.AppEvents_Event;
            Logger.Debug("ExcelEventSubscriptions ʵѴ");
        }

        /// <summary>
        /// Ҫ¼
        /// </summary>
        public void Subscribe()
        {
            if (_isSubscribed)
            {
                Logger.Debug("Subscribe ñԣѶġ");
                return;
            }

            if (_appEvents == null)
            {
                Logger.Warn("޷תΪ AppEvents_Event¼ʧܡ");
                return;
            }

            _workbookOpenHandler = new Excel.AppEvents_WorkbookOpenEventHandler(OnWorkbookOpen);
            _appEvents.WorkbookOpen += _workbookOpenHandler;

            //  Application  SheetActivateʹлʱйOnSheetActivated ڿɸѡ
            _sheetActivateHandler = new Excel.AppEvents_SheetActivateEventHandler(OnSheetActivated);
            _appEvents.SheetActivate += _sheetActivateHandler;

            //  WindowActivateڼʱ
            _windowActivateHandler = new Excel.AppEvents_WindowActivateEventHandler(Application_WindowActivate);
            _appEvents.WindowActivate += _windowActivateHandler;

            //  WorkbookActivateлʱ
            _workbookActivateHandler = new Excel.AppEvents_WorkbookActivateEventHandler(OnWorkbookActivate);
            _appEvents.WorkbookActivate += _workbookActivateHandler;

            _isSubscribed = true;
            Logger.Info("Ѷ Excel Ӧü¼ SheetActivateWindowActivate");
        }

        /// <summary>
        /// ȡģ delegate ã
        /// </summary>
        public void Unsubscribe()
        {
            if (!_isSubscribed)
            {
                Logger.Debug("Unsubscribe ñԣδڶ״̬");
                return;
            }

            if (_appEvents != null)
            {
                if (_workbookOpenHandler != null) _appEvents.WorkbookOpen -= _workbookOpenHandler;
                if (_workbookActivateHandler != null) _appEvents.WorkbookActivate -= _workbookActivateHandler;
                if (_sheetActivateHandler != null) _appEvents.SheetActivate -= _sheetActivateHandler;
                if (_windowActivateHandler != null) _appEvents.WindowActivate -= _windowActivateHandler;
            }

            _workbookOpenHandler = null;
            _workbookActivateHandler = null;
            _sheetActivateHandler = null;
            _windowActivateHandler = null;
            _isSubscribed = false;
            Logger.Info("ȡ Excel Ӧü¼");
        }

       

        // սı
        ~ExcelEventSubscriptions()
        {
            Dispose(false);
        }

        protected virtual void Dispose(bool disposing)
        {
            if (_disposed) return;

            if (disposing)
            {
                // ȫͷйԴ
                Unsubscribe(); // ȡ¼
            }

            // ͷŷйԴеĻ

            _disposed = true;
        }

        public void Dispose()
        {
            //Dispose(true);
            GC.SuppressFinalize(this);
            Logger.Debug("ExcelEventSubscriptions  Dispose");
        }
    }
}