﻿using Microsoft.Office.Tools.Excel;
using NLog;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Xml.Linq;
using Excel = Microsoft.Office.Interop.Excel;
using Office = Microsoft.Office.Core;

namespace ExcelAddInDg
{
    public partial class ThisAddIn
    {
        private static readonly Logger Logger = LogManager.GetCurrentClassLogger();

        // 管理 Excel 事件订阅的实例
        private ExcelEventSubscriptions _excelEvents;
        private readonly object _lockObject = new object();
        private bool _isInitialized = false;
        private void ThisAddIn_Startup(object sender, System.EventArgs e)
        {
            Logger.Info("Add-in 启动 - ThisAddIn_Startup 开始。");


            lock (_lockObject)
            {
                if (_isInitialized) return; // 防止重复初始化

                try
                {
                    _excelEvents = new ExcelEventSubscriptions(this.Application);
                    _excelEvents.Subscribe();
                    _isInitialized = true;

                    Logger.Info("Excel Add-in 启动完成");
                }
                catch (Exception ex)
                {
                    Logger.Info($"Add-in 启动失败: {ex}");
                    // 清理部分初始化的状态
                    _excelEvents?.Dispose();
                    _excelEvents = null;
                }
            }
        }

        private void ThisAddIn_Shutdown(object sender, System.EventArgs e)
        {
            Logger.Info("Add-in 关闭 - ThisAddIn_Shutdown 开始。");

            lock (_lockObject)
            {
                try
                {
                    if (_excelEvents != null)
                    {
                        _excelEvents.Dispose();
                        _excelEvents = null;
                        _isInitialized = false;
                    }

                    Logger.Info("Excel Add-in 关闭完成");
                }
                catch (Exception ex)
                {
                    Logger.Info($"Add-in 关闭过程中发生异常: {ex}");
                }
            }
        
        }

        #region VSTO 生成的代码

        /// <summary>
        /// 设计器支持所需的方法 - 不要修改
        /// 使用代码编辑器修改此方法的内容。    
        /// </summary>
        private void InternalStartup()
        {
            this.Startup += new System.EventHandler(ThisAddIn_Startup);
            this.Shutdown += new System.EventHandler(ThisAddIn_Shutdown);
        }
        
        #endregion
    }
}
